<?php

/**
 * Product: sonnb - Stop Spam Here - FSpamlist API
 * Version: 1.0.1
 * Date: 30th Nov 2012
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * *********Any action to public or redistribute must be authorized from author
 */
class sonnbStopSpamHere_Model_FSpamlist_Model_FSpamlist
{
    private static $timeout = 5;
    
    protected $api_key;
    protected $endpoint = 'http://www.fspamlist.com/api.php';
    
    public function __construct($apiKey = null)
    {
        $this->api_key = $apiKey;
    }
    
    public function get($args)
    {
        $args['key'] = $this->api_key;
        
        $url = $this->endpoint . '?' . http_build_query($args, '', '&').'&serial';

        return $this->poll_json($url);
    }
    
    public function checkRegister($data)
    {
        try
        {
            $dataFS = array(
                'spammer' => $data['email'].','.$data['username'].','.$data['ip']
            );
            
            $records = $this->get($dataFS);

            $spammer = array();
            if ($records)
            {
                if ($records[0]['isspammer'] == true && $records[0]['timesreported'] > 3)
                {
                    $spammer['email'] = $records[0];
                }
                
                if ($records[1]['isspammer'] == true && $records[1]['timesreported'] > 3)
                {
                    $spammer['username'] = $records[1];
                }
                
                if ($records[2]['isspammer'] == true && $records[2]['timesreported'] > 3)
                {
                    $spammer['ip'] = $records[2];
                }
                
                return $spammer;
            }

            return false;
        }
        catch(Exception $e)
        {
            return false;
        }
    }
    
    protected static function poll_json($url)
    {
        try
        {
            $ctx = stream_context_create(array(
                'http' => array(
                    'timeout' => self::$timeout
                )
                    )
            );

            $json = file_get_contents($url, false, $ctx);
            
            switch ($json)
            {
                case 'Incomplete Fields':
                case 'Invalid API Key':
                    //Invalid API Handle
                    break;
            }
            
            $object = @unserialize($json);

            return $object;
        }
        catch (Exception $e)
        {     
            return false;
        }
    }
}

?>
